#include "AD18F08_Com.h"
#include "shell.h"

volatile unsigned char	USART_BUF @0x20;
volatile bit D0			@ ((unsigned)&USART_BUF*8)+0;
volatile bit D1			@ ((unsigned)&USART_BUF*8)+1;
volatile bit D2			@ ((unsigned)&USART_BUF*8)+2;
volatile bit D3			@ ((unsigned)&USART_BUF*8)+3;
volatile bit D4			@ ((unsigned)&USART_BUF*8)+4;
volatile bit D5			@ ((unsigned)&USART_BUF*8)+5;
volatile bit D6			@ ((unsigned)&USART_BUF*8)+6;
volatile bit D7			@ ((unsigned)&USART_BUF*8)+7;

volatile unsigned char UART_Read_FLAG = 0;
volatile unsigned char  RcvDat[20]    = {0};

void usart_init(void)
{
	TX_DIR=0;
	TX_PIN=1;

//	RX_DIR=1;
}

void putch(unsigned char tmp)
{
	USART_BUF = tmp;
	unsigned char i=0;
	TX_PIN = 1;
	TX_PIN = 0;
	__delay_us(104);
	for(i=0;i<8;i++)
	{
		TX_PIN=tmp&0X01;
		__delay_us(100);
		tmp=tmp>>1;
	}
	TX_PIN = 1;
	__delay_us(104);
	__delay_us(104);
}

unsigned char getch(void)
{
	unsigned char  tmp      = 0;
    unsigned char  Time_out = 250;

    while(RX_PIN ==1 )
	{
       Time_out--;
	   if(Time_out == 0)return 0;
	}

	__delay_us(104);
	__delay_us(52);
	if (RX_PIN==1)
		tmp = tmp | 0x01;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x02;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x04;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x08;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x10;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x20;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x40;
	__delay_us(104);

	if (RX_PIN==1)
		tmp = tmp | 0x80;
	__delay_us(104);

	if (RX_PIN==1)
		return tmp;
	else
		return 0;
}


void Tx_Rx_Init(unsigned char UaRt_MoDe)
{
	switch(UaRt_MoDe)
	{
	    case Tx_Init:
	    {
	        Tx_RX_r_Pin_TRIS = 0;
			Tx_RX_t_Pin      = 0;
	    }break;
	    case Rx_Init:
	    {
	        Tx_RX_r_Pin_TRIS = 1;
	    }break;
	    default:
		{
			Tx_RX_r_Pin_TRIS = 1;
		}break;
	}
}

unsigned char get_dat()
{
    unsigned char Temp       = 0;
    unsigned char i          = 0;
    unsigned char HIGH_LEVEL = 0;
    unsigned char LOW_LEVEL  = 0;
    unsigned int  Time_out   = 0;

    Tx_Rx_Init(Rx_Init);

    if(Tx_RX_r_Pin == 0)
	{
	    Time_out = 0;
		while(Tx_RX_r_Pin == 0)
		{
			Time_out ++;
			if(Time_out > 2500)return 0;
        }
		for(i = 0;i < 8;i++)
		{
		    Temp = Temp << 1;
			Time_out = 0;while(Tx_RX_r_Pin != 0){Time_out ++;if(Time_out > 2500){return 0;}}HIGH_LEVEL = Time_out;
			Time_out = 0;while(Tx_RX_r_Pin != 1){Time_out ++;if(Time_out > 2500){return 0;}}LOW_LEVEL  = Time_out;
			if(HIGH_LEVEL < LOW_LEVEL)Temp |= 0x01;
		}
		return Temp;
	}else Time_out = 0;
	return 0;
}

void Send_ch(unsigned char Temp)
{
    unsigned char i = 0;

    Tx_Rx_Init(Tx_Init);

	__delay_us(1000);
	Tx_RX_t_Pin = 1;
	for(i = 0;i < 8;i++)
	{
	   if(Temp & 0x80)
	   {
	       Tx_RX_t_Pin = 1;
		   __delay_us(100);
		   Tx_RX_t_Pin = 0;
		   __delay_us(400);
	   }else {
	       Tx_RX_t_Pin = 1;
		   __delay_us(400);
		   Tx_RX_t_Pin = 0;
		   __delay_us(100);
	   }
	   Temp = Temp << 1;
	}
	Tx_RX_t_Pin = 1;
	__delay_us(5000);
	Tx_Rx_Init(Rx_Init);
}

void Send_Data_Temp(unsigned char Dat_Tmp)
{
	unsigned char  radix_minus_one1 = ((~(Dat_Tmp & 0x0F)) & 0x0F);
	unsigned char  radix_minus_one2 = ((~((Dat_Tmp & 0xF0) >> 4)) & 0x0F);
	unsigned char  Send_Data_4B1 = ((Dat_Tmp & 0x0F) << 4);
	unsigned char  Send_Data_4B2 = (Dat_Tmp & 0xF0);
	unsigned char  Send_Dat1 = Send_Data_4B1 | radix_minus_one1;
	unsigned char  Send_Dat2 = Send_Data_4B2 | radix_minus_one2;

	Send_ch(Send_Dat1);
	Send_ch(Send_Dat2);
}

void Send_CMD(unsigned char Addr,unsigned char Dat)
{
	Send_Data_Temp(0xAA);
	Send_Data_Temp(IC_ID);
	Send_Data_Temp(0x03);
	Send_Data_Temp(Addr);
	Send_Data_Temp(Dat);
	Send_Data_Temp(0xBB);
	Send_Data_Temp(0xCC);
}

void Data_Receive(void)
{

    unsigned char  i                  = 0;
	unsigned char  Time_t             = 0;
    unsigned char  TxRx_ERR_flag      = 0;
    unsigned char  UART_ERR_flag      = 0;
    unsigned char  ch                 = 0;
    unsigned char  RcvDat_TEMP[20]    = {0};

	unsigned char Rec_Data_8B1        = 0;
	unsigned char Rec_Data_8B2        = 0;
	unsigned char Sound_Code1         = 0;
	unsigned char Sound_against_Code1 = 0;
	unsigned char Sound_Code2         = 0;
	unsigned char Sound_against_Code2 = 0;
	unsigned char Delay_Sum           = 0;
	unsigned char Page_Head_Flag      = 0;

    unsigned char Head_DATA1          = 0;
    unsigned char Head_DATA2          = 0;

	do
	{
        //Head_DATA1 = get_dat();
		Head_DATA2 = getch();

        if(Head_DATA1 == 0xA5 || Head_DATA2 == 0xAA)
		{
			if(Head_DATA1 == 0xA5)
			{
				Page_Head_Flag = 1;
			}else if(Head_DATA2 == 0xAA)
			{
				Page_Head_Flag = 2;
			}
		}
		else Page_Head_Flag = 0;

	} while (Page_Head_Flag == 0);

	if(Page_Head_Flag == 1)
	{
		do ch = get_dat();while(ch!=0xA5);
		for(i=0;i<20;i++)
		{
			do{ch = get_dat();Time_t ++;if(Time_t >= 250){ch = Time_t;}}while(ch==0x00);
			RcvDat_TEMP[i] = ch;
			if((RcvDat_TEMP[i]==0xC3) && (RcvDat_TEMP[i-1] == 0xC3) && (RcvDat_TEMP[i-2] == 0xB4) && (RcvDat_TEMP[i-3] == 0xB4)){TxRx_ERR_flag = 1;break;}
			if(Time_t < 250)Time_t = 0;else {Time_t = 0;TxRx_ERR_flag = 0;break;}
		}


		if(TxRx_ERR_flag == 1)
		{
			TxRx_ERR_flag = 0;

			for(i=0;i<20;i++)
			{
				Rec_Data_8B1 = RcvDat_TEMP[Delay_Sum];
				Rec_Data_8B2 = RcvDat_TEMP[Delay_Sum+1];
				Sound_Code1 = ((Rec_Data_8B1 & 0xF0) >> 4);
				Sound_against_Code1 = ((~(Rec_Data_8B1 & 0x0F)) & 0x0F);
				Sound_Code2 = (((Rec_Data_8B2 & 0xF0) >> 4) << 4);
				Sound_against_Code2 = (((~(Rec_Data_8B2 & 0x0F)) & 0x0F) << 4);
				if((Sound_Code1 == Sound_against_Code1) && (Sound_Code2 == Sound_against_Code2))
				{
					RcvDat[i] = Sound_Code1 | Sound_Code2;
				}else{TxRx_ERR_flag = 0;break;}
				if(RcvDat[i]==0xCC && RcvDat[i-1]==0xBB){TxRx_ERR_flag = 2;break;}
				Delay_Sum = Delay_Sum + 2;
			}
			if(TxRx_ERR_flag == 2)
			{
				TxRx_ERR_flag = 0;
				if(RcvDat[0] == IC_ID || RcvDat[0] == Chip_ID)
				{
                    doCmd();
				}else
				{
					for(i = 0;i < 20;i++)printf(" 0x%02X ",RcvDat[i]);
					printf("IC ID is ERROR!\r\n\r\n");
				}
			}else
			{
				//Send_CMD(0x0A,0x00);
				for(i = 0;i < 20;i++)printf(" 0x%02X ",RcvDat[i]);
				printf("DAT2 Error!\r\n\r\n");
			}
		}else
		{
			//Send_CMD(0x0A,0x00);
			for(i = 0;i < 20;i++)printf(" 0x%02X ",RcvDat[i]);
			printf("DAT1 Error!\r\n\r\n");
		}
		for(i = 0;i < 20;i++)RcvDat[i] = 0x00;
    }
	else if(Page_Head_Flag == 2)
	{
        UART_ERR_flag = 0;
		for(i=0;i<30;i++)
		{
			RcvDat[i] = getch();
			if((RcvDat[i] == 0xCC) && (RcvDat[i-1] == 0xBB))
            {
                UART_ERR_flag = 1;
                break;
            }else UART_ERR_flag = 0;
		}
        if(UART_ERR_flag == 1)
        {
            UART_ERR_flag = 0;
			if(RcvDat[0] == IC_ID || RcvDat[0] == Chip_ID)
			{
                doCmd();
			}else
			{
				for(i = 0;i < 20;i++)printf(" 0x%02X ",RcvDat[i]);
				printf("IC ID is ERROR!\r\n\r\n");
			}
        }else{
            printf("UART Dat ERROR\r\n");
        }
	}else{
		printf("Page Head ERROR\r\n");
	}
}
